#!/bin/bash


CONSOLE=" --console"
SERVICE="/lib/systemd/system/assistant.service"

SUDO_FILE="/etc/sudoers.d/assistant"
CURRENT_PATH=`pwd`

cd ../lib

ln -sf libstdc.so.6.0.31 ./libstdc++.so.6.0.31
ln -sf libstdc.so.6.0.31 ./libstdc++.so.6
ln -sf libstdc.so.6.0.31 ./libstdc++.so
	   
ln -sf libcurl.so.4.8.0 ./libcurl.so.4
ln -sf libcurl.so.4.8.0 ./libcurl.so
	   
ln -sf libcrypto.so.3 ./libcrypto.so
ln -sf libssl.so.3 ./libssl.so
	   
ln -sf libvpx.so.6.2.0 ./libvpx.so.6.2
ln -sf libvpx.so.6.2.0 ./libvpx.so.6
ln -sf libvpx.so.6.2.0 ./libvpx.so
	   
ln -sf libxkbcommon.so.0.0.0 ./libxkbcommon.so.0
ln -sf libxkbcommon.so.0.0.0 ./libxkbcommon.so

rm -f libast*.so.2*
rm -f libhatls.so.2*
rm -f libstdc++.so.6.0.23
rm -f libcurl.so.4.5.0
rm -f libcurl.so.4.7.0
rm -f libssl.so.1.1
rm -f libcrypto.so.1.1
rm -f libcrypto.so.1
rm -f libssl.so.1
rm -f libusbast.so.*

cd $CURRENT_PATH

echo "root ALL=(ALL) /opt/assistant/bin/" > $SUDO_FILE
echo "root ALL=(ALL) /opt/assistant/scripts/" >> $SUDO_FILE
echo "root ALL=(ALL) /sbin/setcap" >> $SUDO_FILE
echo "Defaults env_keep += \"DISPLAY XAUTHORITY\"" >> $SUDO_FILE

[[ -f $SUDO_FILE ]] && chmod 0400 $SUDO_FILE

! grep -q -- $CONSOLE $SERVICE && CONSOLE=""
sed -i "s/ExecStart=.*/ExecStart=\/opt\/assistant\/scripts\/runasts.sh --start$CONSOLE/" $SERVICE
sed -i "s/ExecStop=.*/ExecStop=\/opt\/assistant\/scripts\/runasts.sh --stop/" $SERVICE
systemctl daemon-reload
systemctl start assistant.service

. ../scripts/setup.sh

cert --install
trusted --install
set_shell_ini --install
add_libudev_links --install
disable_pam_lightdm --install

exit 0