#!/bin/bash

LOG_TO_FILE=/opt/assistant/log/daemon.log
LIB_SYSTEMD=/lib/systemd/system/
ETC_SYSTEMD=/etc/systemd/system/
INST_DIR=/opt/assistant
SCRIPTS_DIR=$INST_DIR/scripts



if [[ -L /sbin/init ]] && [[ $(readlink /sbin/init | sed -r 's/.*\///') == 'systemd' ]]; then
	SYS='systemd'
elif [[ $(openrc -V 2> /dev/null | awk '{print $1}' ) == 'openrc' ]]; then
    SYS='openrc'
else 
	SYS='none'
fi

echo "Found '$SYS' initialization system"

#
# check root sudo entry
#

SUDO_MAIN_PATTERN="#includedir /etc/sudoers.d"
SUDO_MAIN_REGEXP_PATTERN="#includedir \/etc\/sudoers.d"
SUDO_MAIN_FILE="/etc/sudoers"

SUDO_PATTERN="root ALL=(ALL) /opt/assistant/bin/"
SUDO_PATTERN_SCRIPTS="root ALL=(ALL) $SCRIPTS_DIR/"
SUDO_PATTERN_SETCAP="root ALL=(ALL) /sbin/setcap"
DEFAULTS_ENV="Defaults env_keep += \"DISPLAY XAUTHORITY\""

SUDO_OLD_REGEXP_PATTERN="root ALL=(ALL) \/opt\/assistant\/bin\/assistant"
SUDO_FILE="/etc/sudoers.d/assistant"


add_sudo_entry(){
	# add sudo dir
    if grep -q "$SUDO_MAIN_REGEXP_PATTERN" 2> /dev/null $SUDO_MAIN_FILE
    then 
        echo "Sudo main entry already exist" >> $LOG_TO_FILE
        echo "Sudo main entry already exist"
    else
        echo "Adding sudo main entry"
        echo "Adding sudo main entry" >> $LOG_TO_FILE
        echo "$SUDO_MAIN_PATTERN" >> $SUDO_MAIN_FILE
    fi
    # create /etc/sudoers.d/assistant
    if ! [ -d /etc/sudoers.d ]
    then
        mkdir /etc/sudoers.d
    fi
	
    echo "$SUDO_PATTERN" > $SUDO_FILE
    echo "$SUDO_PATTERN_SCRIPTS" >> $SUDO_FILE
    echo "$SUDO_PATTERN_SETCAP" >> $SUDO_FILE
    echo "$DEFAULTS_ENV" >> $SUDO_FILE
	[[ -f $SUDO_FILE ]] && echo "Added file '$SUDO_FILE'"

    # remove old sudo task
    if grep -q "$SUDO_OLD_REGEXP_PATTERN" 2> /dev/null $SUDO_MAIN_FILE
    then
        echo "Removing old sudo entry" >> $LOG_TO_FILE
        echo "Removing old sudo entry"
		sed -i "/${SUDO_OLD_REGEXP_PATTERN}/d" $SUDO_MAIN_FILE
    fi
    
    chmod 0400 $SUDO_FILE
}


remove_sudo(){
    echo "Remove sudo file" >> $LOG_TO_FILE
    echo "Remove sudo file"
    rm -f $SUDO_FILE
}


#
# create service
#

case $SYS in
	'systemd')
		case $1 in 
		"--install" | "-i")
			add_sudo_entry
			if [[ -d $LIB_SYSTEMD ]]; then
				mv -f $SCRIPTS_DIR/assistant.service $LIB_SYSTEMD/assistant.service
			elif [[ -d $ETC_SYSTEMD ]]; then
				mv -f $SCRIPTS_DIR/assistant.service $ETC_SYSTEMD/assistant.service
			else 
				echo 'Failed to install the unit'
				exit 1
			fi
			systemctl enable assistant.service 2>> $LOG_TO_FILE 
			if [ $? == 0 ]; then echo "Daemon installed"; fi
			systemctl start assistant.service
			
			rm -f $SCRIPTS_DIR/openrc.s 
			rm -f $SCRIPTS_DIR/openrc.t 
			rm -f $SCRIPTS_DIR/ast_restart.t
		;;
		"--uninstall" | "-u")
			remove_sudo
			systemctl stop assistant.service
			systemctl disable  assistant.service
			
			touch $SCRIPTS_DIR/assistant.service 
			touch $SCRIPTS_DIR/openrc.s 
			touch $SCRIPTS_DIR/openrc.t 
			touch $SCRIPTS_DIR/ast_restart.t
		;;
		esac
	;;
	'openrc')
		case $1 in
		"--install" | "-i")
			add_sudo_entry
			echo "Calculate linux detected, run openRC setup"
			rc-update delete zassistantd
			eselect rc stop zassistantd
			cp $SCRIPTS_DIR/openrc.s /etc/init.d/zassistantd
			cp $SCRIPTS_DIR/openrc.t $SCRIPTS_DIR/runasts.sh 
			cp $SCRIPTS_DIR/ast_restart.t $SCRIPTS_DIR/ast_restart.sh

			chmod +x /etc/init.d/zassistantd

			echo "Files copied"

			/sbin/rc-update add zassistantd default
			/sbin/rc-service zassistantd start

			echo "Service runned"
			#
			# create cron task
			#
			CRON_PATTERN='*/1 * * * * root '$SCRIPTS_DIR'/ast_restart.sh'
			CRON_REGEXP_PATTERN="^\*\/1 \* \* \* \* root \/opt\/assistant\/scripts\/ast_restart\.sh$"
			CRON_FILE="/etc/crontab"

			if grep -q "$CRON_REGEXP_PATTERN" 2> /dev/null $CRON_FILE
			then 
				echo "Crontab entry already exist" >> $LOG_TO_FILE
				echo "Crontab entry already exist"
			else
				echo "Adding crontab entry" >> $LOG_TO_FILE
				echo "Adding crontab entry"
				echo "$CRON_PATTERN" >> $CRON_FILE
			fi
			rm -f $SCRIPTS_DIR/assistant.service 
			echo "Cron task created"
		;;
		"--uninstall" | "-u")
			remove_sudo
			CRON_PATTERN='*/1 * * * * root '$SCRIPTS_DIR'/ast_restart.sh'
			CRON_REGEXP_PATTERN='^\*\/1 \* \* \* \* root \/opt\/assistant\/scripts\/ast_restart\.sh$'
			CRON_FILE="/etc/crontab"
				# remove old cron task
				if grep -q "$CRON_REGEXP_PATTERN" 2> /dev/null $CRON_FILE
				then
					echo "Removing old cron entry" 
					sed -i "/${CRON_REGEXP_PATTERN}/d" $CRON_FILE
				fi
			rc-update delete zassistantd
			eselect rc stop zassistantd

		    kill `pidof asts astrct assistant master slave ffmpeg` 2> /dev/null
			touch $SCRIPTS_DIR/assistant.service 
		;;
		esac
	;;
	'none')
			echo "init system not found"
			exit 1
	;;
	*)
			echo "Invalid params: "\"$*\"
			exit 1
	;;
esac

exit 0
